/**
 * Class to view Login
 *
 * Adilson L. Magnus <info@magnussolution.com> 
 * 08/07/2014
 */
/*
Se ja esta logado, nao pedir nada


Se logar, verificar se esta ativo o google ou nao

se nao estiver, passar direto

se tiver ativo, validar o codigo
*/
Ext.define('MBilling.view.main.GoogleAuthenticator', {
    extend: 'Ext.window.Window',
    alias: 'widget.googleauthenticator',
    controller: 'googleauthenticator',
    xtype: 'googleauthenticator',
    glyph: icons.lock,
    cls: 'auth-locked-window',
    closable: false,
    resizable: false,
    autoShow: true,
    titleAlign: 'center',
    maximized: true,
    modal: true,
    layout: {
        type: 'vbox',
        align: 'center',
        pack: 'center'
    },
    initComponent: function() {
        var me = this;
        me.height = me.newKey || me.showGoogleCode ? 320 : 140;
        var secretKey = me.keyGoogle.split('secret%');
        me.title = t('Second authentication factor');
        me.items = [{
            defaultFocus: 'textfield:focusable:not([hidden]):not([disabled]):not([value])',
            cls: 'auth-dialog',
            defaultButton: 'loginButton',
            autoComplete: true,
            bodyPadding: '20 20',
            header: false,
            width: 415,
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            defaults: {
                margin: '5 0'
            },
            items: [{
                xtype: 'label',
                text: t('ONE TIME PASSWORD')
            }, {
                xtype: 'textfield',
                cls: 'auth-textbox',
                height: 55,
                hideLabel: true,
                allowBlank: false,
                reference: 'oneCode',
                inputAttrTpl: " data-qtip='Provider the current code generated by your Google Authenticator App' ",
                minLength: 6,
                maxLength: 6
            }, {
                xtype: 'label',
                text: t('Scan this code') + ' (' + t('Backup the manual code') + ')',
                hidden: !me.newKey && !me.showGoogleCode
            }, {
                xtype: 'image',
                height: 220,
                margin: '0 70 0 70',
                src: me.keyGoogle,
                hidden: !me.newKey && !me.showGoogleCode
            }, {
                xtype: 'displayfield',
                fieldLabel: t('Manual code'),
                value: secretKey[1],
                allowBlank: true,
                hidden: !me.newKey && !me.showGoogleCode
            }, {
                xtype: 'displayfield',
                value: '<a target="_black" href="https://www.google.com/search?&q=google+authenticator&oq=google+authenticator"> ' + t('Download APP') + '<a/>',
                allowBlank: true,
                hidden: !me.newKey && !me.showGoogleCode
            }, {
                xtype: 'displayfield',
                fieldLabel: t('Code name'),
                value: 'VoIP-' + me.username + '-' + me.userId,
                allowBlank: true,
                hidden: !me.newKey
            }, {
                layout: 'hbox',
                items: [{
                    xtype: 'button',
                    flex: 1,
                    margin: '0 0 0 5',
                    reference: 'cancelButton',
                    scale: 'large',
                    iconAlign: 'right',
                    iconCls: 'x-fa fa-angle-right',
                    text: t('Cancel'),
                    formBind: true,
                    handler: 'onLogout'
                }, {
                    xtype: 'button',
                    flex: 1,
                    margin: '0 0 0 5',
                    reference: 'loginButton',
                    scale: 'large',
                    iconAlign: 'right',
                    iconCls: 'x-fa fa-angle-right',
                    text: t('Login'),
                    formBind: true,
                    handler: 'onGoogleAuthenticator'
                }]
            }]
        }]
        me.callParent(arguments);
    }
});