<?php


namespace Dnetix\Redirection\Validators;


class Currency extends BaseValidator
{

    const CUR_COP = 'COP';
    const CUR_USD = 'USD';
    const CUR_MXN = 'MXN';
    const CUR_AUD = 'AUD';

    const CUR_AFN = 'AFN';
    const CUR_AED = 'AED';
    const CUR_ALL = 'ALL';
    const CUR_AMD = 'AMD';
    const CUR_ANG = 'ANG';
    const CUR_AOA = 'AOA';
    const CUR_ARS = 'ARS';
    const CUR_AWG = 'AWG';
    const CUR_AZN = 'AZN';
    const CUR_BAM = 'BAM';
    const CUR_BBD = 'BBD';
    const CUR_BDT = 'BDT';
    const CUR_BGN = 'BGN';
    const CUR_BHD = 'BHD';
    const CUR_BIF = 'BIF';
    const CUR_BMD = 'BMD';
    const CUR_BND = 'BND';
    const CUR_BOB = 'BOB';
    const CUR_BOV = 'BOV';
    const CUR_BRL = 'BRL';
    const CUR_BSD = 'BSD';
    const CUR_BTN = 'BTN';
    const CUR_BWP = 'BWP';
    const CUR_BYN = 'BYN';
    const CUR_BZD = 'BZD';
    const CUR_CAD = 'CAD';
    const CUR_CDF = 'CDF';
    const CUR_CHE = 'CHE';
    const CUR_CHF = 'CHF';
    const CUR_CHW = 'CHW';
    const CUR_CLF = 'CLF';
    const CUR_CLP = 'CLP';
    const CUR_CNY = 'CNY';
    const CUR_COU = 'COU';
    const CUR_CRC = 'CRC';
    const CUR_CUC = 'CUC';
    const CUR_CUP = 'CUP';
    const CUR_CVE = 'CVE';
    const CUR_CZK = 'CZK';
    const CUR_DJF = 'DJF';
    const CUR_DKK = 'DKK';
    const CUR_DOP = 'DOP';
    const CUR_DZD = 'DZD';
    const CUR_EGP = 'EGP';
    const CUR_ERN = 'ERN';
    const CUR_ETB = 'ETB';
    const CUR_EUR = 'EUR';
    const CUR_FJD = 'FJD';
    const CUR_FKP = 'FKP';
    const CUR_GBP = 'GBP';
    const CUR_GEL = 'GEL';
    const CUR_GHS = 'GHS';
    const CUR_GIP = 'GIP';
    const CUR_GMD = 'GMD';
    const CUR_GNF = 'GNF';
    const CUR_GTQ = 'GTQ';
    const CUR_GYD = 'GYD';
    const CUR_HKD = 'HKD';
    const CUR_HNL = 'HNL';
    const CUR_HRK = 'HRK';
    const CUR_HTG = 'HTG';
    const CUR_HUF = 'HUF';
    const CUR_IDR = 'IDR';
    const CUR_ILS = 'ILS';
    const CUR_INR = 'INR';
    const CUR_IQD = 'IQD';
    const CUR_IRR = 'IRR';
    const CUR_ISK = 'ISK';
    const CUR_JMD = 'JMD';
    const CUR_JOD = 'JOD';
    const CUR_JPY = 'JPY';
    const CUR_KES = 'KES';
    const CUR_KGS = 'KGS';
    const CUR_KHR = 'KHR';
    const CUR_KMF = 'KMF';
    const CUR_KPW = 'KPW';
    const CUR_KRW = 'KRW';
    const CUR_KWD = 'KWD';
    const CUR_KYD = 'KYD';
    const CUR_KZT = 'KZT';
    const CUR_LAK = 'LAK';
    const CUR_LBP = 'LBP';
    const CUR_LKR = 'LKR';
    const CUR_LRD = 'LRD';
    const CUR_LSL = 'LSL';
    const CUR_LYD = 'LYD';
    const CUR_MAD = 'MAD';
    const CUR_MDL = 'MDL';
    const CUR_MGA = 'MGA';
    const CUR_MKD = 'MKD';
    const CUR_MMK = 'MMK';
    const CUR_MNT = 'MNT';
    const CUR_MOP = 'MOP';
    const CUR_MRO = 'MRO';
    const CUR_MUR = 'MUR';
    const CUR_MVR = 'MVR';
    const CUR_MWK = 'MWK';
    const CUR_MXV = 'MXV';
    const CUR_MYR = 'MYR';
    const CUR_MZN = 'MZN';
    const CUR_NAD = 'NAD';
    const CUR_NGN = 'NGN';
    const CUR_NIO = 'NIO';
    const CUR_NOK = 'NOK';
    const CUR_NPR = 'NPR';
    const CUR_NZD = 'NZD';
    const CUR_OMR = 'OMR';
    const CUR_PAB = 'PAB';
    const CUR_PEN = 'PEN';
    const CUR_PGK = 'PGK';
    const CUR_PHP = 'PHP';
    const CUR_PKR = 'PKR';
    const CUR_PLN = 'PLN';
    const CUR_PYG = 'PYG';
    const CUR_QAR = 'QAR';
    const CUR_RON = 'RON';
    const CUR_RSD = 'RSD';
    const CUR_RUB = 'RUB';
    const CUR_RWF = 'RWF';
    const CUR_SAR = 'SAR';
    const CUR_SBD = 'SBD';
    const CUR_SCR = 'SCR';
    const CUR_SDG = 'SDG';
    const CUR_SEK = 'SEK';
    const CUR_SGD = 'SGD';
    const CUR_SHP = 'SHP';
    const CUR_SLL = 'SLL';
    const CUR_SOS = 'SOS';
    const CUR_SRD = 'SRD';
    const CUR_SSP = 'SSP';
    const CUR_STD = 'STD';
    const CUR_SVC = 'SVC';
    const CUR_SYP = 'SYP';
    const CUR_SZL = 'SZL';
    const CUR_THB = 'THB';
    const CUR_TJS = 'TJS';
    const CUR_TMT = 'TMT';
    const CUR_TND = 'TND';
    const CUR_TOP = 'TOP';
    const CUR_TRY = 'TRY';
    const CUR_TTD = 'TTD';
    const CUR_TWD = 'TWD';
    const CUR_TZS = 'TZS';
    const CUR_UAH = 'UAH';
    const CUR_UGX = 'UGX';
    const CUR_USN = 'USN';
    const CUR_UYI = 'UYI';
    const CUR_UYU = 'UYU';
    const CUR_UZS = 'UZS';
    const CUR_VEF = 'VEF';
    const CUR_VND = 'VND';
    const CUR_VUV = 'VUV';
    const CUR_WST = 'WST';
    const CUR_XAF = 'XAF';
    const CUR_XAG = 'XAG';
    const CUR_XAU = 'XAU';
    const CUR_XBA = 'XBA';
    const CUR_XBB = 'XBB';
    const CUR_XBC = 'XBC';
    const CUR_XBD = 'XBD';
    const CUR_XCD = 'XCD';
    const CUR_XDR = 'XDR';
    const CUR_XOF = 'XOF';
    const CUR_XPD = 'XPD';
    const CUR_XPF = 'XPF';
    const CUR_XPT = 'XPT';
    const CUR_XSU = 'XSU';
    const CUR_XTS = 'XTS';
    const CUR_XUA = 'XUA';
    const CUR_XXX = 'XXX';
    const CUR_YER = 'YER';
    const CUR_ZAR = 'ZAR';
    const CUR_ZMW = 'ZMW';
    const CUR_ZWL = 'ZWL';

    public static $currencyNames = [
        self::CUR_AFN => 'Afghani',
        self::CUR_AED => 'UAE Dirham',
        self::CUR_ALL => 'Lek',
        self::CUR_AMD => 'Armenian Dram',
        self::CUR_ANG => 'Netherlands Antillean Guilder',
        self::CUR_AOA => 'Kwanza',
        self::CUR_ARS => 'Argentine Peso',
        self::CUR_AUD => 'Australian Dollar',
        self::CUR_AWG => 'Aruban Florin',
        self::CUR_AZN => 'Azerbaijanian Manat',
        self::CUR_BAM => 'Convertible Mark',
        self::CUR_BBD => 'Barbados Dollar',
        self::CUR_BDT => 'Taka',
        self::CUR_BGN => 'Bulgarian Lev',
        self::CUR_BHD => 'Bahraini Dinar',
        self::CUR_BIF => 'Burundi Franc',
        self::CUR_BMD => 'Bermudian Dollar',
        self::CUR_BND => 'Brunei Dollar',
        self::CUR_BOB => 'Boliviano',
        self::CUR_BOV => 'Mvdol',
        self::CUR_BRL => 'Brazilian Real',
        self::CUR_BSD => 'Bahamian Dollar',
        self::CUR_BTN => 'Ngultrum',
        self::CUR_BWP => 'Pula',
        self::CUR_BYN => 'Belarusian Ruble',
        self::CUR_BZD => 'Belize Dollar',
        self::CUR_CAD => 'Canadian Dollar',
        self::CUR_CDF => 'Congolese Franc',
        self::CUR_CHE => 'WIR Euro',
        self::CUR_CHF => 'Swiss Franc',
        self::CUR_CHW => 'WIR Franc',
        self::CUR_CLF => 'Unidad de Fomento',
        self::CUR_CLP => 'Chilean Peso',
        self::CUR_CNY => 'Yuan Renminbi',
        self::CUR_COP => 'Colombian Peso',
        self::CUR_COU => 'Unidad de Valor Real',
        self::CUR_CRC => 'Costa Rican Colon',
        self::CUR_CUC => 'Peso Convertible',
        self::CUR_CUP => 'Cuban Peso',
        self::CUR_CVE => 'Cabo Verde Escudo',
        self::CUR_CZK => 'Czech Koruna',
        self::CUR_DJF => 'Djibouti Franc',
        self::CUR_DKK => 'Danish Krone',
        self::CUR_DOP => 'Dominican Peso',
        self::CUR_DZD => 'Algerian Dinar',
        self::CUR_EGP => 'Egyptian Pound',
        self::CUR_ERN => 'Nakfa',
        self::CUR_ETB => 'Ethiopian Birr',
        self::CUR_EUR => 'Euro',
        self::CUR_FJD => 'Fiji Dollar',
        self::CUR_FKP => 'Falkland Islands Pound',
        self::CUR_GBP => 'Pound Sterling',
        self::CUR_GEL => 'Lari',
        self::CUR_GHS => 'Ghana Cedi',
        self::CUR_GIP => 'Gibraltar Pound',
        self::CUR_GMD => 'Dalasi',
        self::CUR_GNF => 'Guinea Franc',
        self::CUR_GTQ => 'Quetzal',
        self::CUR_GYD => 'Guyana Dollar',
        self::CUR_HKD => 'Hong Kong Dollar',
        self::CUR_HNL => 'Lempira',
        self::CUR_HRK => 'Kuna',
        self::CUR_HTG => 'Gourde',
        self::CUR_HUF => 'Forint',
        self::CUR_IDR => 'Rupiah',
        self::CUR_ILS => 'New Israeli Sheqel',
        self::CUR_INR => 'Indian Rupee',
        self::CUR_IQD => 'Iraqi Dinar',
        self::CUR_IRR => 'Iranian Rial',
        self::CUR_ISK => 'Iceland Krona',
        self::CUR_JMD => 'Jamaican Dollar',
        self::CUR_JOD => 'Jordanian Dinar',
        self::CUR_JPY => 'Yen',
        self::CUR_KES => 'Kenyan Shilling',
        self::CUR_KGS => 'Som',
        self::CUR_KHR => 'Riel',
        self::CUR_KMF => 'Comoro Franc',
        self::CUR_KPW => 'North Korean Won',
        self::CUR_KRW => 'Won',
        self::CUR_KWD => 'Kuwaiti Dinar',
        self::CUR_KYD => 'Cayman Islands Dollar',
        self::CUR_KZT => 'Tenge',
        self::CUR_LAK => 'Kip',
        self::CUR_LBP => 'Lebanese Pound',
        self::CUR_LKR => 'Sri Lanka Rupee',
        self::CUR_LRD => 'Liberian Dollar',
        self::CUR_LSL => 'Loti',
        self::CUR_LYD => 'Libyan Dinar',
        self::CUR_MAD => 'Moroccan Dirham',
        self::CUR_MDL => 'Moldovan Leu',
        self::CUR_MGA => 'Malagasy Ariary',
        self::CUR_MKD => 'Denar',
        self::CUR_MMK => 'Kyat',
        self::CUR_MNT => 'Tugrik',
        self::CUR_MOP => 'Pataca',
        self::CUR_MRO => 'Ouguiya',
        self::CUR_MUR => 'Mauritius Rupee',
        self::CUR_MVR => 'Rufiyaa',
        self::CUR_MWK => 'Malawi Kwacha',
        self::CUR_MXN => 'Mexican Peso',
        self::CUR_MXV => 'Mexican Unidad de Inversion (UDI)',
        self::CUR_MYR => 'Malaysian Ringgit',
        self::CUR_MZN => 'Mozambique Metical',
        self::CUR_NAD => 'Namibia Dollar',
        self::CUR_NGN => 'Naira',
        self::CUR_NIO => 'Cordoba Oro',
        self::CUR_NOK => 'Norwegian Krone',
        self::CUR_NPR => 'Nepalese Rupee',
        self::CUR_NZD => 'New Zealand Dollar',
        self::CUR_OMR => 'Rial Omani',
        self::CUR_PAB => 'Balboa',
        self::CUR_PEN => 'Sol',
        self::CUR_PGK => 'Kina',
        self::CUR_PHP => 'Philippine Peso',
        self::CUR_PKR => 'Pakistan Rupee',
        self::CUR_PLN => 'Zloty',
        self::CUR_PYG => 'Guarani',
        self::CUR_QAR => 'Qatari Rial',
        self::CUR_RON => 'Romanian Leu',
        self::CUR_RSD => 'Serbian Dinar',
        self::CUR_RUB => 'Russian Ruble',
        self::CUR_RWF => 'Rwanda Franc',
        self::CUR_SAR => 'Saudi Riyal',
        self::CUR_SBD => 'Solomon Islands Dollar',
        self::CUR_SCR => 'Seychelles Rupee',
        self::CUR_SDG => 'Sudanese Pound',
        self::CUR_SEK => 'Swedish Krona',
        self::CUR_SGD => 'Singapore Dollar',
        self::CUR_SHP => 'Saint Helena Pound',
        self::CUR_SLL => 'Leone',
        self::CUR_SOS => 'Somali Shilling',
        self::CUR_SRD => 'Surinam Dollar',
        self::CUR_SSP => 'South Sudanese Pound',
        self::CUR_STD => 'Dobra',
        self::CUR_SVC => 'El Salvador Colon',
        self::CUR_SYP => 'Syrian Pound',
        self::CUR_SZL => 'Lilangeni',
        self::CUR_THB => 'Baht',
        self::CUR_TJS => 'Somoni',
        self::CUR_TMT => 'Turkmenistan New Manat',
        self::CUR_TND => 'Tunisian Dinar',
        self::CUR_TOP => 'Paanga',
        self::CUR_TRY => 'Turkish Lira',
        self::CUR_TTD => 'Trinidad and Tobago Dollar',
        self::CUR_TWD => 'New Taiwan Dollar',
        self::CUR_TZS => 'Tanzanian Shilling',
        self::CUR_UAH => 'Hryvnia',
        self::CUR_UGX => 'Uganda Shilling',
        self::CUR_USD => 'US Dollar',
        self::CUR_USN => 'US Dollar (Next day)',
        self::CUR_UYI => 'Uruguay Peso en Unidades Indexadas (URUIURUI)',
        self::CUR_UYU => 'Peso Uruguayo',
        self::CUR_UZS => 'Uzbekistan Sum',
        self::CUR_VEF => 'Bolvar',
        self::CUR_VND => 'Dong',
        self::CUR_VUV => 'Vatu',
        self::CUR_WST => 'Tala',
        self::CUR_XAF => 'CFA Franc BEAC',
        self::CUR_XAG => 'Silver',
        self::CUR_XAU => 'Gold',
        self::CUR_XBA => 'Bond Markets Unit European Composite Unit (EURCO)',
        self::CUR_XBB => 'Bond Markets Unit European Monetary Unit (E.M.U.-6)',
        self::CUR_XBC => 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)',
        self::CUR_XBD => 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)',
        self::CUR_XCD => 'East Caribbean Dollar',
        self::CUR_XDR => 'SDR (Special Drawing Right)',
        self::CUR_XOF => 'CFA Franc BCEAO',
        self::CUR_XPD => 'Palladium',
        self::CUR_XPF => 'CFP Franc',
        self::CUR_XPT => 'Platinum',
        self::CUR_XSU => 'Sucre',
        self::CUR_XTS => 'Codes specifically reserved for testing purposes',
        self::CUR_XUA => 'ADB Unit of Account',
        self::CUR_XXX => 'The codes assigned for transactions where no currency is involved',
        self::CUR_YER => 'Yemeni Rial',
        self::CUR_ZAR => 'Rand',
        self::CUR_ZMW => 'Zambian Kwacha',
        self::CUR_ZWL => 'Zimbabwe Dollar',
    ];

    public static $currencyNumericCodes = [
        self::CUR_AFN => '971',
        self::CUR_EUR => '978',
        self::CUR_ALL => '008',
        self::CUR_DZD => '012',
        self::CUR_USD => '840',
        self::CUR_AOA => '973',
        self::CUR_XCD => '951',
        self::CUR_ARS => '032',
        self::CUR_AMD => '051',
        self::CUR_AWG => '533',
        self::CUR_AUD => '036',
        self::CUR_AZN => '944',
        self::CUR_BSD => '044',
        self::CUR_BHD => '048',
        self::CUR_BDT => '050',
        self::CUR_BBD => '052',
        self::CUR_BYN => '933',
        self::CUR_BZD => '084',
        self::CUR_XOF => '952',
        self::CUR_BMD => '060',
        self::CUR_INR => '356',
        self::CUR_BTN => '064',
        self::CUR_BOB => '068',
        self::CUR_BOV => '984',
        self::CUR_BAM => '977',
        self::CUR_BWP => '072',
        self::CUR_NOK => '578',
        self::CUR_BRL => '986',
        self::CUR_BND => '096',
        self::CUR_BGN => '975',
        self::CUR_BIF => '108',
        self::CUR_CVE => '132',
        self::CUR_KHR => '116',
        self::CUR_XAF => '950',
        self::CUR_CAD => '124',
        self::CUR_KYD => '136',
        self::CUR_CLP => '152',
        self::CUR_CLF => '990',
        self::CUR_CNY => '156',
        self::CUR_COP => '170',
        self::CUR_COU => '970',
        self::CUR_KMF => '174',
        self::CUR_CDF => '976',
        self::CUR_NZD => '554',
        self::CUR_CRC => '188',
        self::CUR_HRK => '191',
        self::CUR_CUP => '192',
        self::CUR_CUC => '931',
        self::CUR_ANG => '532',
        self::CUR_CZK => '203',
        self::CUR_DKK => '208',
        self::CUR_DJF => '262',
        self::CUR_DOP => '214',
        self::CUR_EGP => '818',
        self::CUR_SVC => '222',
        self::CUR_ERN => '232',
        self::CUR_ETB => '230',
        self::CUR_FKP => '238',
        self::CUR_FJD => '242',
        self::CUR_XPF => '953',
        self::CUR_GMD => '270',
        self::CUR_GEL => '981',
        self::CUR_GHS => '936',
        self::CUR_GIP => '292',
        self::CUR_GTQ => '320',
        self::CUR_GBP => '826',
        self::CUR_GNF => '324',
        self::CUR_GYD => '328',
        self::CUR_HTG => '332',
        self::CUR_HNL => '340',
        self::CUR_HKD => '344',
        self::CUR_HUF => '348',
        self::CUR_ISK => '352',
        self::CUR_IDR => '360',
        self::CUR_XDR => '960',
        self::CUR_IRR => '364',
        self::CUR_IQD => '368',
        self::CUR_ILS => '376',
        self::CUR_JMD => '388',
        self::CUR_JPY => '392',
        self::CUR_JOD => '400',
        self::CUR_KZT => '398',
        self::CUR_KES => '404',
        self::CUR_KPW => '408',
        self::CUR_KRW => '410',
        self::CUR_KWD => '414',
        self::CUR_KGS => '417',
        self::CUR_LAK => '418',
        self::CUR_LBP => '422',
        self::CUR_LSL => '426',
        self::CUR_ZAR => '710',
        self::CUR_LRD => '430',
        self::CUR_LYD => '434',
        self::CUR_CHF => '756',
        self::CUR_MOP => '446',
        self::CUR_MKD => '807',
        self::CUR_MGA => '969',
        self::CUR_MWK => '454',
        self::CUR_MYR => '458',
        self::CUR_MVR => '462',
        self::CUR_MRO => '478',
        self::CUR_MUR => '480',
        self::CUR_XUA => '965',
        self::CUR_MXN => '484',
        self::CUR_MXV => '979',
        self::CUR_MDL => '498',
        self::CUR_MNT => '496',
        self::CUR_MAD => '504',
        self::CUR_MZN => '943',
        self::CUR_MMK => '104',
        self::CUR_NAD => '516',
        self::CUR_NPR => '524',
        self::CUR_NIO => '558',
        self::CUR_NGN => '566',
        self::CUR_OMR => '512',
        self::CUR_PKR => '586',
        self::CUR_PAB => '590',
        self::CUR_PGK => '598',
        self::CUR_PYG => '600',
        self::CUR_PEN => '604',
        self::CUR_PHP => '608',
        self::CUR_PLN => '985',
        self::CUR_QAR => '634',
        self::CUR_RON => '946',
        self::CUR_RUB => '643',
        self::CUR_RWF => '646',
        self::CUR_SHP => '654',
        self::CUR_WST => '882',
        self::CUR_STD => '678',
        self::CUR_SAR => '682',
        self::CUR_RSD => '941',
        self::CUR_SCR => '690',
        self::CUR_SLL => '694',
        self::CUR_SGD => '702',
        self::CUR_XSU => '994',
        self::CUR_SBD => '090',
        self::CUR_SOS => '706',
        self::CUR_SSP => '728',
        self::CUR_LKR => '144',
        self::CUR_SDG => '938',
        self::CUR_SRD => '968',
        self::CUR_SZL => '748',
        self::CUR_SEK => '752',
        self::CUR_CHE => '947',
        self::CUR_CHW => '948',
        self::CUR_SYP => '760',
        self::CUR_TWD => '901',
        self::CUR_TJS => '972',
        self::CUR_TZS => '834',
        self::CUR_THB => '764',
        self::CUR_TOP => '776',
        self::CUR_TTD => '780',
        self::CUR_TND => '788',
        self::CUR_TRY => '949',
        self::CUR_TMT => '934',
        self::CUR_UGX => '800',
        self::CUR_UAH => '980',
        self::CUR_AED => '784',
        self::CUR_USN => '997',
        self::CUR_UYU => '858',
        self::CUR_UYI => '940',
        self::CUR_UZS => '860',
        self::CUR_VUV => '548',
        self::CUR_VEF => '937',
        self::CUR_VND => '704',
        self::CUR_YER => '886',
        self::CUR_ZMW => '967',
        self::CUR_ZWL => '932',
        self::CUR_XBA => '955',
        self::CUR_XBB => '956',
        self::CUR_XBC => '957',
        self::CUR_XBD => '958',
        self::CUR_XTS => '963',
        self::CUR_XXX => '999',
        self::CUR_XAU => '959',
        self::CUR_XPD => '964',
        self::CUR_XPT => '962',
        self::CUR_XAG => '961',
    ];

    public static function currencyName($currency)
    {
        if (isset(self::$currencyNames[$currency]))
            return self::$currencyNames[$currency];

        return null;
    }

    public static function currencyNumericCode($currency)
    {
        if (isset(self::$currencyNumericCodes[$currency]))
            return self::$currencyNumericCodes[$currency];

        return null;
    }

    public static function numericCodeToCurrency($numericCode)
    {
        $currencies = array_flip(self::$currencyNumericCodes);

        if (isset($currencies[$numericCode]))
            return $currencies[$numericCode];

        return null;
    }

    public static function isValidCurrency($currency)
    {
        return array_key_exists($currency, self::$currencyNames);
    }

}